/*
 * Decompiled with CFR 0.152.
 */
package com.deepdevlabs.playeressentials.init;

import com.deepdevlabs.playeressentials.init.PlayerEssentialsModScreens;
import com.deepdevlabs.playeressentials.network.MenuStateUpdateMessage;
import com.deepdevlabs.playeressentials.world.inventory.EntityInspectorPanelMenu;
import com.deepdevlabs.playeressentials.world.inventory.SettingsMenu;
import com.deepdevlabs.playeressentials.world.inventory.StatsOverlayMenu;
import com.deepdevlabs.playeressentials.world.inventory.TeleportInspectorMenu;
import com.deepdevlabs.playeressentials.world.inventory.UpdateGUIMenu;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PlayerEssentialsModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"player_essentials");
    public static final DeferredHolder<MenuType<?>, MenuType<StatsOverlayMenu>> STATS_OVERLAY = REGISTRY.register("stats_overlay", () -> IMenuTypeExtension.create(StatsOverlayMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<EntityInspectorPanelMenu>> ENTITY_INSPECTOR_PANEL = REGISTRY.register("entity_inspector_panel", () -> IMenuTypeExtension.create(EntityInspectorPanelMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<UpdateGUIMenu>> UPDATE_GUI = REGISTRY.register("update_gui", () -> IMenuTypeExtension.create(UpdateGUIMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<SettingsMenu>> SETTINGS = REGISTRY.register("settings", () -> IMenuTypeExtension.create(SettingsMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<TeleportInspectorMenu>> TELEPORT_INSPECTOR = REGISTRY.register("teleport_inspector", () -> IMenuTypeExtension.create(TeleportInspectorMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (player.level().isClientSide) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof PlayerEssentialsModScreens.ScreenAccessor) {
                    PlayerEssentialsModScreens.ScreenAccessor accessor = (PlayerEssentialsModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

