/*
 * Decompiled with CFR 0.152.
 */
package com.deepdevlabs.playeressentials.network;

import com.deepdevlabs.playeressentials.PlayerEssentialsMod;
import com.deepdevlabs.playeressentials.procedures.ApplyButtonPressedProcedure;
import com.deepdevlabs.playeressentials.procedures.SaveLocationButtonPressedProcedure;
import com.deepdevlabs.playeressentials.procedures.SaveLocationEntityButtonPressedProcedure;
import com.deepdevlabs.playeressentials.procedures.SelectedEntityTeleportProcedure;
import com.deepdevlabs.playeressentials.procedures.TeleportToLocationButtonPressedProcedure;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record TeleportInspectorButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TeleportInspectorButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_essentials", (String)"teleport_inspector_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportInspectorButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new TeleportInspectorButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<TeleportInspectorButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(TeleportInspectorButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> TeleportInspectorButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.getChunkSource().hasChunk(SectionPos.blockToSectionCoord((int)x), SectionPos.blockToSectionCoord((int)z))) {
            return;
        }
        if (buttonID == 0) {
            SaveLocationButtonPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            TeleportToLocationButtonPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            ApplyButtonPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            SelectedEntityTeleportProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 4) {
            SaveLocationEntityButtonPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PlayerEssentialsMod.addNetworkMessage(TYPE, STREAM_CODEC, TeleportInspectorButtonMessage::handleData);
    }
}

