/*
 * Decompiled with CFR 0.152.
 */
package com.deepdevlabs.playeressentials.network;

import com.deepdevlabs.playeressentials.PlayerEssentialsMod;
import com.deepdevlabs.playeressentials.procedures.AbsourdExplosionsButtonProcedure;
import com.deepdevlabs.playeressentials.procedures.BloodScreenPressedProcedure;
import com.deepdevlabs.playeressentials.procedures.LEAPButtonProcedure;
import com.deepdevlabs.playeressentials.procedures.ModOverlayPressedProcedure;
import com.deepdevlabs.playeressentials.procedures.SuperPowersPressedProcedure;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record SettingsButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SettingsButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_essentials", (String)"settings_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SettingsButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new SettingsButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SettingsButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(SettingsButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> SettingsButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.getChunkSource().hasChunk(SectionPos.blockToSectionCoord((int)x), SectionPos.blockToSectionCoord((int)z))) {
            return;
        }
        if (buttonID == 0) {
            SuperPowersPressedProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 1) {
            BloodScreenPressedProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 2) {
            ModOverlayPressedProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 3) {
            LEAPButtonProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 4) {
            AbsourdExplosionsButtonProcedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PlayerEssentialsMod.addNetworkMessage(TYPE, STREAM_CODEC, SettingsButtonMessage::handleData);
    }
}

