/*
 * Decompiled with CFR 0.152.
 */
package com.deepdevlabs.playeressentials.network;

import com.deepdevlabs.playeressentials.PlayerEssentialsMod;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class PlayerEssentialsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"player_essentials");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());
    public static Entity LastEntityAttackedPlayer = null;
    public static Entity GetInspectorEntity = null;
    public static Entity CombactEntity1 = null;
    public static Entity CombactEntity2 = null;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        PlayerEssentialsMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        PlayerEssentialsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(PlayerEssentialsModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(PlayerEssentialsModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        if (!event.isWasDeath()) {
            clone.True_Sprint = original.True_Sprint;
            clone.EntityScanAmmount = original.EntityScanAmmount;
            clone.RayTP = original.RayTP;
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapVariables mapdata = MapVariables.get((LevelAccessor)player2.level());
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)player2.level());
            if (mapdata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer player;
        WorldVariables worlddata;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (worlddata = WorldVariables.get((LevelAccessor)(player = (ServerPlayer)player2).level())) != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
            if (worldVariables._syncDirty) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level2, (CustomPacketPayload)new SavedDataSyncMessage(1, worldVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                worldVariables._syncDirty = false;
            }
            MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
            if (mapVariables._syncDirty) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, mapVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                mapVariables._syncDirty = false;
            }
        }
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_essentials", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_essentials", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public boolean True_Sprint = true;
        public double EntityScanAmmount = 0.0;
        public boolean RayTP = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("True_Sprint", this.True_Sprint);
            nbt.putDouble("EntityScanAmmount", this.EntityScanAmmount);
            nbt.putBoolean("RayTP", this.RayTP);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.True_Sprint = nbt.getBoolean("True_Sprint");
            this.EntityScanAmmount = nbt.getDouble("EntityScanAmmount");
            this.RayTP = nbt.getBoolean("RayTP");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "player_essentials_mapvars";
        boolean _syncDirty = false;
        public double Crithitsammount = 0.0;
        public double TotalEntityKillCount = 0.0;
        public double SubEntityPopup = 1.0;
        public double ScanRange = 14.0;
        public double LEAP_Health = 0.0;
        public boolean LEAP_Display = false;
        public boolean LEAP_AutoDisplay = false;
        public String LEAPStatus = "\"\"";
        public String LEAP_Status2 = "\"\"";
        public String InspectEntityXYZ = "";
        public double InspectorentityX = 0.0;
        public double InspectorentityY = 0.0;
        public double InspectorentityZ = 0.0;
        public boolean ModOverlay = false;
        public double PlayerInspectorBlocksBroken = 0.0;
        public boolean Superpowers = false;
        public boolean Bloodscreen = false;
        public boolean HasCheated = false;
        public boolean AllowExtreemeExplosions = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.Crithitsammount = nbt.getDouble("Crithitsammount");
            this.TotalEntityKillCount = nbt.getDouble("TotalEntityKillCount");
            this.SubEntityPopup = nbt.getDouble("SubEntityPopup");
            this.ScanRange = nbt.getDouble("ScanRange");
            this.LEAP_Health = nbt.getDouble("LEAP_Health");
            this.LEAP_Display = nbt.getBoolean("LEAP_Display");
            this.LEAP_AutoDisplay = nbt.getBoolean("LEAP_AutoDisplay");
            this.LEAPStatus = nbt.getString("LEAPStatus");
            this.LEAP_Status2 = nbt.getString("LEAP_Status2");
            this.InspectEntityXYZ = nbt.getString("InspectEntityXYZ");
            this.InspectorentityX = nbt.getDouble("InspectorentityX");
            this.InspectorentityY = nbt.getDouble("InspectorentityY");
            this.InspectorentityZ = nbt.getDouble("InspectorentityZ");
            this.ModOverlay = nbt.getBoolean("ModOverlay");
            this.PlayerInspectorBlocksBroken = nbt.getDouble("PlayerInspectorBlocksBroken");
            this.Superpowers = nbt.getBoolean("Superpowers");
            this.Bloodscreen = nbt.getBoolean("Bloodscreen");
            this.HasCheated = nbt.getBoolean("HasCheated");
            this.AllowExtreemeExplosions = nbt.getBoolean("AllowExtreemeExplosions");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("Crithitsammount", this.Crithitsammount);
            nbt.putDouble("TotalEntityKillCount", this.TotalEntityKillCount);
            nbt.putDouble("SubEntityPopup", this.SubEntityPopup);
            nbt.putDouble("ScanRange", this.ScanRange);
            nbt.putDouble("LEAP_Health", this.LEAP_Health);
            nbt.putBoolean("LEAP_Display", this.LEAP_Display);
            nbt.putBoolean("LEAP_AutoDisplay", this.LEAP_AutoDisplay);
            nbt.putString("LEAPStatus", this.LEAPStatus);
            nbt.putString("LEAP_Status2", this.LEAP_Status2);
            nbt.putString("InspectEntityXYZ", this.InspectEntityXYZ);
            nbt.putDouble("InspectorentityX", this.InspectorentityX);
            nbt.putDouble("InspectorentityY", this.InspectorentityY);
            nbt.putDouble("InspectorentityZ", this.InspectorentityZ);
            nbt.putBoolean("ModOverlay", this.ModOverlay);
            nbt.putDouble("PlayerInspectorBlocksBroken", this.PlayerInspectorBlocksBroken);
            nbt.putBoolean("Superpowers", this.Superpowers);
            nbt.putBoolean("Bloodscreen", this.Bloodscreen);
            nbt.putBoolean("HasCheated", this.HasCheated);
            nbt.putBoolean("AllowExtreemeExplosions", this.AllowExtreemeExplosions);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "player_essentials_worldvars";
        boolean _syncDirty = false;
        public double PlayerInspectorBlocksPlaced = 0.0;
        public double SecondsInWorld = 0.0;
        public double SavePlayerTPX = 0.0;
        public double SavePlayerTPY = 0.0;
        public double SavePlayerTPZ = 0.0;
        public boolean HasSavedTPLocation = false;
        public double SaveSelectedEntityX = 0.0;
        public double SaveSelectedEntityY = 0.0;
        public double SaveSelectedEntityZ = 0.0;
        public boolean CreationMode = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.PlayerInspectorBlocksPlaced = nbt.getDouble("PlayerInspectorBlocksPlaced");
            this.SecondsInWorld = nbt.getDouble("SecondsInWorld");
            this.SavePlayerTPX = nbt.getDouble("SavePlayerTPX");
            this.SavePlayerTPY = nbt.getDouble("SavePlayerTPY");
            this.SavePlayerTPZ = nbt.getDouble("SavePlayerTPZ");
            this.HasSavedTPLocation = nbt.getBoolean("HasSavedTPLocation");
            this.SaveSelectedEntityX = nbt.getDouble("SaveSelectedEntityX");
            this.SaveSelectedEntityY = nbt.getDouble("SaveSelectedEntityY");
            this.SaveSelectedEntityZ = nbt.getDouble("SaveSelectedEntityZ");
            this.CreationMode = nbt.getBoolean("CreationMode");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("PlayerInspectorBlocksPlaced", this.PlayerInspectorBlocksPlaced);
            nbt.putDouble("SecondsInWorld", this.SecondsInWorld);
            nbt.putDouble("SavePlayerTPX", this.SavePlayerTPX);
            nbt.putDouble("SavePlayerTPY", this.SavePlayerTPY);
            nbt.putDouble("SavePlayerTPZ", this.SavePlayerTPZ);
            nbt.putBoolean("HasSavedTPLocation", this.HasSavedTPLocation);
            nbt.putDouble("SaveSelectedEntityX", this.SaveSelectedEntityX);
            nbt.putDouble("SaveSelectedEntityY", this.SaveSelectedEntityY);
            nbt.putDouble("SaveSelectedEntityZ", this.SaveSelectedEntityZ);
            nbt.putBoolean("CreationMode", this.CreationMode);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }
}

