/*
 * Decompiled with CFR 0.152.
 */
package com.deepdevlabs.playeressentials.client.gui;

import com.deepdevlabs.playeressentials.init.PlayerEssentialsModScreens;
import com.deepdevlabs.playeressentials.network.TeleportInspectorButtonMessage;
import com.deepdevlabs.playeressentials.procedures.SavedLocationReturnProcedure;
import com.deepdevlabs.playeressentials.procedures.SelectedEntityLocationReturnProcedure;
import com.deepdevlabs.playeressentials.procedures.SelectedEntityLocationSaveReturnProcedure;
import com.deepdevlabs.playeressentials.procedures.SelectedEntityNameReturnProcedure;
import com.deepdevlabs.playeressentials.procedures.TeleporttoLocationbuttonShowReturnProcedure;
import com.deepdevlabs.playeressentials.world.inventory.TeleportInspectorMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class TeleportInspectorScreen
extends AbstractContainerScreen<TeleportInspectorMenu>
implements PlayerEssentialsModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox LocationX;
    private EditBox LocationY;
    private EditBox LocationZ;
    private EditBox EntityLocationX;
    private EditBox EntityLocationY;
    private EditBox EntityLocationZ;
    private Button button_set_waypoint;
    private Button button_teleport_to_waypoint;
    private Button button_apply;
    private Button button_teleport;
    private Button button_save_location;
    private static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"player_essentials:textures/screens/teleport_inspector.png");

    public TeleportInspectorScreen(TeleportInspectorMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 400;
        this.imageHeight = 226;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("LocationX")) {
                this.LocationX.setValue(stringState);
            } else if (name.equals("LocationY")) {
                this.LocationY.setValue(stringState);
            } else if (name.equals("LocationZ")) {
                this.LocationZ.setValue(stringState);
            } else if (name.equals("EntityLocationX")) {
                this.EntityLocationX.setValue(stringState);
            } else if (name.equals("EntityLocationY")) {
                this.EntityLocationY.setValue(stringState);
            } else if (name.equals("EntityLocationZ")) {
                this.EntityLocationZ.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.LocationX.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.LocationY.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.LocationZ.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.EntityLocationX.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.EntityLocationY.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.EntityLocationZ.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.LocationX.isFocused()) {
            return this.LocationX.keyPressed(key, b, c);
        }
        if (this.LocationY.isFocused()) {
            return this.LocationY.keyPressed(key, b, c);
        }
        if (this.LocationZ.isFocused()) {
            return this.LocationZ.keyPressed(key, b, c);
        }
        if (this.EntityLocationX.isFocused()) {
            return this.EntityLocationX.keyPressed(key, b, c);
        }
        if (this.EntityLocationY.isFocused()) {
            return this.EntityLocationY.keyPressed(key, b, c);
        }
        if (this.EntityLocationZ.isFocused()) {
            return this.EntityLocationZ.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String LocationXValue = this.LocationX.getValue();
        String LocationYValue = this.LocationY.getValue();
        String LocationZValue = this.LocationZ.getValue();
        String EntityLocationXValue = this.EntityLocationX.getValue();
        String EntityLocationYValue = this.EntityLocationY.getValue();
        String EntityLocationZValue = this.EntityLocationZ.getValue();
        super.resize(minecraft, width, height);
        this.LocationX.setValue(LocationXValue);
        this.LocationY.setValue(LocationYValue);
        this.LocationZ.setValue(LocationZValue);
        this.EntityLocationX.setValue(EntityLocationXValue);
        this.EntityLocationY.setValue(EntityLocationYValue);
        this.EntityLocationZ.setValue(EntityLocationZValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.label_teleport_inspector"), 150, 7, -6750055, false);
        if (TeleporttoLocationbuttonShowReturnProcedure.execute((LevelAccessor)this.world)) {
            guiGraphics.drawString(this.font, SavedLocationReturnProcedure.execute((LevelAccessor)this.world), 18, 86, -6750055, false);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.label_manual_location"), 27, 125, -6750055, false);
        guiGraphics.drawString(this.font, SelectedEntityNameReturnProcedure.execute(), 270, 35, -6750055, false);
        guiGraphics.drawString(this.font, SelectedEntityLocationReturnProcedure.execute(), 282, 54, -6750055, false);
        guiGraphics.drawString(this.font, SelectedEntityLocationSaveReturnProcedure.execute((LevelAccessor)this.world), 281, 92, -6750055, false);
    }

    public void init() {
        super.init();
        this.LocationX = new EditBox(this.font, this.leftPos + 17, this.topPos + 144, 26, 18, (Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.LocationX"));
        this.LocationX.setMaxLength(8192);
        this.LocationX.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleportInspectorMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "LocationX", content, false);
            }
        });
        this.LocationX.setHint((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.LocationX"));
        this.addWidget((GuiEventListener)this.LocationX);
        this.LocationY = new EditBox(this.font, this.leftPos + 53, this.topPos + 144, 23, 18, (Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.LocationY"));
        this.LocationY.setMaxLength(8192);
        this.LocationY.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleportInspectorMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "LocationY", content, false);
            }
        });
        this.LocationY.setHint((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.LocationY"));
        this.addWidget((GuiEventListener)this.LocationY);
        this.LocationZ = new EditBox(this.font, this.leftPos + 87, this.topPos + 144, 30, 18, (Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.LocationZ"));
        this.LocationZ.setMaxLength(8192);
        this.LocationZ.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleportInspectorMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "LocationZ", content, false);
            }
        });
        this.LocationZ.setHint((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.LocationZ"));
        this.addWidget((GuiEventListener)this.LocationZ);
        this.EntityLocationX = new EditBox(this.font, this.leftPos + 273, this.topPos + 70, 28, 18, (Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.EntityLocationX"));
        this.EntityLocationX.setMaxLength(8192);
        this.EntityLocationX.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleportInspectorMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "EntityLocationX", content, false);
            }
        });
        this.EntityLocationX.setHint((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.EntityLocationX"));
        this.addWidget((GuiEventListener)this.EntityLocationX);
        this.EntityLocationY = new EditBox(this.font, this.leftPos + 312, this.topPos + 70, 27, 18, (Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.EntityLocationY"));
        this.EntityLocationY.setMaxLength(8192);
        this.EntityLocationY.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleportInspectorMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "EntityLocationY", content, false);
            }
        });
        this.EntityLocationY.setHint((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.EntityLocationY"));
        this.addWidget((GuiEventListener)this.EntityLocationY);
        this.EntityLocationZ = new EditBox(this.font, this.leftPos + 350, this.topPos + 70, 32, 18, (Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.EntityLocationZ"));
        this.EntityLocationZ.setMaxLength(8192);
        this.EntityLocationZ.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleportInspectorMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "EntityLocationZ", content, false);
            }
        });
        this.EntityLocationZ.setHint((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.EntityLocationZ"));
        this.addWidget((GuiEventListener)this.EntityLocationZ);
        this.button_set_waypoint = Button.builder((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.button_set_waypoint"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new TeleportInspectorButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            TeleportInspectorButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 21, this.topPos + 35, 85, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_set_waypoint);
        this.button_teleport_to_waypoint = Button.builder((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.button_teleport_to_waypoint"), e -> {
            int x = this.x;
            int y = this.y;
            if (TeleporttoLocationbuttonShowReturnProcedure.execute((LevelAccessor)this.world)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new TeleportInspectorButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
                TeleportInspectorButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
            }
        }).bounds(this.leftPos + 7, this.topPos + 62, 125, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_teleport_to_waypoint);
        this.button_apply = Button.builder((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.button_apply"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new TeleportInspectorButtonMessage(2, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            TeleportInspectorButtonMessage.handleButtonAction(this.entity, 2, x, y, this.z);
        }).bounds(this.leftPos + 39, this.topPos + 166, 50, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_apply);
        this.button_teleport = Button.builder((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.button_teleport"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new TeleportInspectorButtonMessage(3, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            TeleportInspectorButtonMessage.handleButtonAction(this.entity, 3, x, y, this.z);
        }).bounds(this.leftPos + 303, this.topPos + 137, 65, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_teleport);
        this.button_save_location = Button.builder((Component)Component.translatable((String)"gui.player_essentials.teleport_inspector.button_save_location"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new TeleportInspectorButtonMessage(4, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            TeleportInspectorButtonMessage.handleButtonAction(this.entity, 4, x, y, this.z);
        }).bounds(this.leftPos + 289, this.topPos + 111, 90, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_save_location);
    }

    protected void containerTick() {
        super.containerTick();
        this.button_teleport_to_waypoint.visible = TeleporttoLocationbuttonShowReturnProcedure.execute((LevelAccessor)this.world);
    }
}

