/*
 * Decompiled with CFR 0.152.
 */
package com.deepdevlabs.playeressentials.client.gui;

import com.deepdevlabs.playeressentials.init.PlayerEssentialsModScreens;
import com.deepdevlabs.playeressentials.network.SettingsButtonMessage;
import com.deepdevlabs.playeressentials.procedures.AbsourdExplosionTextProcedure;
import com.deepdevlabs.playeressentials.procedures.BloodScreenStatReturnProcedure;
import com.deepdevlabs.playeressentials.procedures.LEAPButtonTextProcedure;
import com.deepdevlabs.playeressentials.procedures.ModOverlayReturnProcedure;
import com.deepdevlabs.playeressentials.procedures.SuperPowersStatReturnProcedure;
import com.deepdevlabs.playeressentials.world.inventory.SettingsMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class SettingsScreen
extends AbstractContainerScreen<SettingsMenu>
implements PlayerEssentialsModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox PlayerPopUp;
    private EditBox DetectionRage;
    private Button button_speed_boost;
    private Button button_blood_overlay;
    private Button button_mod_overlay;
    private Button button_last_attacker;
    private Button button_absourdexplosions;
    private static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"player_essentials:textures/screens/settings.png");

    public SettingsScreen(SettingsMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 405;
        this.imageHeight = 214;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("PlayerPopUp")) {
                this.PlayerPopUp.setValue(stringState);
            } else if (name.equals("DetectionRage")) {
                this.DetectionRage.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.PlayerPopUp.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.DetectionRage.render(guiGraphics, mouseX, mouseY, partialTicks);
        boolean customTooltipShown = false;
        if (mouseX > this.leftPos + 37 && mouseX < this.leftPos + 61 && mouseY > this.topPos + 54 && mouseY < this.topPos + 78) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.player_essentials.settings.tooltip_enabledisable_resistance_and_sp"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (mouseX > this.leftPos + 37 && mouseX < this.leftPos + 61 && mouseY > this.topPos + 87 && mouseY < this.topPos + 111) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.player_essentials.settings.tooltip_type_javabedrockminimal"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (mouseX > this.leftPos + 36 && mouseX < this.leftPos + 60 && mouseY > this.topPos + 118 && mouseY < this.topPos + 142) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.player_essentials.settings.tooltip_set_the_detection_rage_you_can_s"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (!customTooltipShown) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.PlayerPopUp.isFocused()) {
            return this.PlayerPopUp.keyPressed(key, b, c);
        }
        if (this.DetectionRage.isFocused()) {
            return this.DetectionRage.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String PlayerPopUpValue = this.PlayerPopUp.getValue();
        String DetectionRageValue = this.DetectionRage.getValue();
        super.resize(minecraft, width, height);
        this.PlayerPopUp.setValue(PlayerPopUpValue);
        this.DetectionRage.setValue(DetectionRageValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.player_essentials.settings.label_player_essentails_settings"), 135, 8, -16763905, false);
        guiGraphics.drawString(this.font, SuperPowersStatReturnProcedure.execute((LevelAccessor)this.world), 32, 40, -65536, false);
        guiGraphics.drawString(this.font, BloodScreenStatReturnProcedure.execute((LevelAccessor)this.world), 134, 40, -65536, false);
        guiGraphics.drawString(this.font, ModOverlayReturnProcedure.execute((LevelAccessor)this.world), 126, 76, -65536, false);
        guiGraphics.drawString(this.font, LEAPButtonTextProcedure.execute((LevelAccessor)this.world), 128, 109, -52429, false);
        guiGraphics.drawString(this.font, AbsourdExplosionTextProcedure.execute((LevelAccessor)this.world), 308, 41, -65536, false);
    }

    public void init() {
        super.init();
        this.PlayerPopUp = new EditBox(this.font, this.leftPos + 10, this.topPos + 87, 77, 18, (Component)Component.translatable((String)"gui.player_essentials.settings.PlayerPopUp"));
        this.PlayerPopUp.setMaxLength(8192);
        this.PlayerPopUp.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((SettingsMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "PlayerPopUp", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.PlayerPopUp);
        this.DetectionRage = new EditBox(this.font, this.leftPos + 37, this.topPos + 121, 24, 18, (Component)Component.translatable((String)"gui.player_essentials.settings.DetectionRage"));
        this.DetectionRage.setMaxLength(8192);
        this.DetectionRage.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((SettingsMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "DetectionRage", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.DetectionRage);
        this.button_speed_boost = Button.builder((Component)Component.translatable((String)"gui.player_essentials.settings.button_speed_boost"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SettingsButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SettingsButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 9, this.topPos + 55, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_speed_boost);
        this.button_blood_overlay = Button.builder((Component)Component.translatable((String)"gui.player_essentials.settings.button_blood_overlay"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SettingsButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SettingsButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
        }).bounds(this.leftPos + 104, this.topPos + 54, 90, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_blood_overlay);
        this.button_mod_overlay = Button.builder((Component)Component.translatable((String)"gui.player_essentials.settings.button_mod_overlay"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SettingsButtonMessage(2, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SettingsButtonMessage.handleButtonAction(this.entity, 2, x, y, this.z);
        }).bounds(this.leftPos + 106, this.topPos + 86, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_mod_overlay);
        this.button_last_attacker = Button.builder((Component)Component.translatable((String)"gui.player_essentials.settings.button_last_attacker"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SettingsButtonMessage(3, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SettingsButtonMessage.handleButtonAction(this.entity, 3, x, y, this.z);
        }).bounds(this.leftPos + 102, this.topPos + 122, 90, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_last_attacker);
        this.button_absourdexplosions = Button.builder((Component)Component.translatable((String)"gui.player_essentials.settings.button_absourdexplosions"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SettingsButtonMessage(4, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SettingsButtonMessage.handleButtonAction(this.entity, 4, x, y, this.z);
        }).bounds(this.leftPos + 271, this.topPos + 54, 110, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_absourdexplosions);
    }
}

