/*
 * Decompiled with CFR 0.152.
 */
package com.deepdevlabs.playeressentials.network;

import com.deepdevlabs.playeressentials.PlayerEssentialsMod;
import com.deepdevlabs.playeressentials.procedures.OpenGUIPressedProcedure;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record OpenGUIMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenGUIMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_essentials", (String)"key_open_gui"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenGUIMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new OpenGUIMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<OpenGUIMessage> type() {
        return TYPE;
    }

    public static void handleData(OpenGUIMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> OpenGUIMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.getChunkSource().hasChunk(SectionPos.blockToSectionCoord((double)x), SectionPos.blockToSectionCoord((double)z))) {
            return;
        }
        if (type == 0) {
            OpenGUIPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PlayerEssentialsMod.addNetworkMessage(TYPE, STREAM_CODEC, OpenGUIMessage::handleData);
    }
}

