/*
 * Decompiled with CFR 0.152.
 */
package com.deepdevlabs.playeressentials.client.gui;

import com.deepdevlabs.playeressentials.init.PlayerEssentialsModScreens;
import com.deepdevlabs.playeressentials.network.StatsOverlayButtonMessage;
import com.deepdevlabs.playeressentials.procedures.LEAPButtonTextProcedure;
import com.deepdevlabs.playeressentials.procedures.PlayerInfoOverlayReturnEntityProcedure;
import com.deepdevlabs.playeressentials.procedures.ReturnCritDamageProcedure;
import com.deepdevlabs.playeressentials.procedures.ReturnDetectRangeValueProcedure;
import com.deepdevlabs.playeressentials.procedures.ReturnEntityInAreaProcedure;
import com.deepdevlabs.playeressentials.procedures.ReturnPlayerDestroysBlockProcedure;
import com.deepdevlabs.playeressentials.procedures.ReturnPlayerPlacedBlockProcedure;
import com.deepdevlabs.playeressentials.procedures.ReturnTotalKillCountProcedure;
import com.deepdevlabs.playeressentials.world.inventory.StatsOverlayMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class StatsOverlayScreen
extends AbstractContainerScreen<StatsOverlayMenu>
implements PlayerEssentialsModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox PlayerPopUp;
    private EditBox AreaDetectionRange;
    private Button button_entity_inspetor;
    private Button button_lastattacker;
    private static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"player_essentials:textures/screens/stats_overlay.png");

    public StatsOverlayScreen(StatsOverlayMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 397;
        this.imageHeight = 185;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("PlayerPopUp")) {
                this.PlayerPopUp.setValue(stringState);
            } else if (name.equals("AreaDetectionRange")) {
                this.AreaDetectionRange.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.PlayerPopUp.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.AreaDetectionRange.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = PlayerInfoOverlayReturnEntityProcedure.execute((Entity)this.entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            PlayerEssentialsModScreens.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 328, this.topPos + 152, 40, 0.5f + (float)Math.atan((double)(this.leftPos + 328 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 103 - mouseY) / 40.0), livingEntity);
        }
        boolean customTooltipShown = false;
        if (mouseX > this.leftPos + 347 && mouseX < this.leftPos + 371 && mouseY > this.topPos + 12 && mouseY < this.topPos + 36) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.player_essentials.stats_overlay.tooltip_type_javabedrockminimal"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (mouseX > this.leftPos + 294 && mouseX < this.leftPos + 318 && mouseY > this.topPos + 35 && mouseY < this.topPos + 59) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.player_essentials.stats_overlay.tooltip_type_14_20"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (!customTooltipShown) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.PlayerPopUp.isFocused()) {
            return this.PlayerPopUp.keyPressed(key, b, c);
        }
        if (this.AreaDetectionRange.isFocused()) {
            return this.AreaDetectionRange.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String PlayerPopUpValue = this.PlayerPopUp.getValue();
        String AreaDetectionRangeValue = this.AreaDetectionRange.getValue();
        super.resize(minecraft, width, height);
        this.PlayerPopUp.setValue(PlayerPopUpValue);
        this.AreaDetectionRange.setValue(AreaDetectionRangeValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, ReturnCritDamageProcedure.execute((LevelAccessor)this.world), 6, 9, -65536, false);
        guiGraphics.drawString(this.font, ReturnTotalKillCountProcedure.execute((LevelAccessor)this.world), 6, 20, -65536, false);
        guiGraphics.drawString(this.font, ReturnEntityInAreaProcedure.execute((Entity)this.entity), 5, 56, -65536, false);
        guiGraphics.drawString(this.font, LEAPButtonTextProcedure.execute((LevelAccessor)this.world), 33, 141, -65536, false);
        guiGraphics.drawString(this.font, ReturnDetectRangeValueProcedure.execute((LevelAccessor)this.world), 325, 42, -65536, false);
        guiGraphics.drawString(this.font, ReturnPlayerDestroysBlockProcedure.execute((LevelAccessor)this.world), 6, 32, -65536, false);
        guiGraphics.drawString(this.font, ReturnPlayerPlacedBlockProcedure.execute((LevelAccessor)this.world), 5, 44, -65536, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.player_essentials.stats_overlay.label_proc_return_sys_time"), 5, 68, -65536, false);
    }

    public void init() {
        super.init();
        this.PlayerPopUp = new EditBox(this.font, this.leftPos + 295, this.topPos + 14, 76, 18, (Component)Component.translatable((String)"gui.player_essentials.stats_overlay.PlayerPopUp"));
        this.PlayerPopUp.setMaxLength(8192);
        this.PlayerPopUp.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((StatsOverlayMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "PlayerPopUp", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.PlayerPopUp);
        this.AreaDetectionRange = new EditBox(this.font, this.leftPos + 295, this.topPos + 38, 23, 18, (Component)Component.translatable((String)"gui.player_essentials.stats_overlay.AreaDetectionRange"));
        this.AreaDetectionRange.setMaxLength(8192);
        this.AreaDetectionRange.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((StatsOverlayMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "AreaDetectionRange", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.AreaDetectionRange);
        this.button_entity_inspetor = Button.builder((Component)Component.translatable((String)"gui.player_essentials.stats_overlay.button_entity_inspetor"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new StatsOverlayButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            StatsOverlayButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 279, this.topPos + 156, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_entity_inspetor);
        this.button_lastattacker = Button.builder((Component)Component.translatable((String)"gui.player_essentials.stats_overlay.button_lastattacker"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new StatsOverlayButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            StatsOverlayButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
        }).bounds(this.leftPos + 11, this.topPos + 156, 85, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_lastattacker);
    }
}

